from django.shortcuts import render
from django.contrib.auth.models import User
from .utils import generate_random_string, CATEGORIES

def create_random_user(request):
    context = {"categories": CATEGORIES.keys()}

    if request.method == "POST":
        # Get selected categories from form
        username_categories = request.POST.getlist("username_categories")
        password_categories = request.POST.getlist("password_categories")
        username_length = int(request.POST.get("username_length", 8))
        password_length = int(request.POST.get("password_length", 12))

        # Generate username and password
        username = generate_random_string(username_categories, username_length)
        password = generate_random_string(password_categories, password_length)

        # Create user in database
        user = User.objects.create_user(username=username, password=password)
        user.save()

        context.update({
            "success": True,
            "username": username,
            "password": password,
            "selected_username_categories": username_categories,
            "selected_password_categories": password_categories,
            "username_length": username_length,
            "password_length": password_length
        })

    return render(request, "random_user.html", context)
